<?php
require './inc/header.php';
?>
<img id="mySpinner" src="cube.gif" ng-show="loading" />
		<div class="container contentBody">

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">
					<button class="btn btn-link"  ng-click="exportData()">Export to Excel</button> <b>Showing {{names.length}} Records</b>
<!--<button ng-csv="names" filename="test.csv" csv-header="['ID', 'Name', 'Email','Mobile', 'Company', 'Call Back','Days', 'Coming', 'Nos','IPAddress','Time']">NG Export</button>-->
				</div>

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12" id="custReport">

					<table class="table table-bordered">

						<thead>
							<th>#</th>
							<th>Name</th>
							<th>Email</th>
							<th>Mobile</th>
							<th>Company</th>
							<th>Days</th>							
							<th>Attending</th>
							<th>Members</th>
							<th>CallBack</th>
							<th>Date ( UAE Time)</th>
							<th>Last Updated</th>
						</thead>
						<tbody>
							<tr ng-repeat="x in names">
								<td>{{ $index + 1 }}</td>
								<td>{{x.name | uppercase }}</td>
								<td style="max-width: 200px !Important;word-wrap:break-word;">{{x.email}}</td>
								<td>{{x.mobile}}</td>
								<td style="max-width: 150px !Important;word-wrap:break-word;">{{x.company}}</td>
								<td style="width:170px;">
									<span ng-if="x.days.split(',')[0]!='' && x.days.split(',')[0]!='0'" class="daySep">Day {{x.days.split(',')[0]}}</span>
									<span ng-if="x.days.split(',')[1]!='' && x.days.split(',')[1]!='0'" class="daySep">Day {{x.days.split(',')[1]}}</span>
									<span ng-if="x.days.split(',')[2]!='' && x.days.split(',')[2]!='0'" class="daySep">Day {{x.days.split(',')[2]}}</span>
									<span ng-if="x.days.split(',')[3]!='' && x.days.split(',')[3]!='0'" class="daySep">Day {{x.days.split(',')[3]}}</span>
								</td>
								<td>{{x.attending_with}}</td>
								<td><span ng-if="x.attending_with=='Family'">{{x.family_members}}</span></td>
								<td><span ng-if="x.contactback=='Yes'">Yes</span><span ng-if="x.contactback=='No'" >No</span></td>
								<td>{{x.cust_date | date:'d/m/yyyy'}}</td>
								<td>{{x.updated_on | date:'d/m/yyyy'}}</td>
							</tr>
						</tbody>
					</table>

				</div>

			</div>

		</div>

	</div>
	
</body>
<script type="text/javascript">

	var app=angular.module("myApp" , []);

	app.controller("usercontroller", function($scope, $http){

		$scope.displayData = function(){
$scope.loading = true;
			$http.get("select.php")
			.success(function(data){
				$scope.names = data;
			})
.finally(function () {
      // Hide loading spinner whether our call succeeded or failed.
      $scope.loading = false;
    });
		}


		$scope.exportData = function () {
			var blob = new Blob([document.getElementById('custReport').innerHTML], {
			type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8"
			});
			saveAs(blob, "ikkf-visitors.xls");
		};
	});

</script>
</html>