<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>IKKF Customer Data Collection</title>
	<!-- Bootstrap -->
	<link href='http://fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,200' rel='stylesheet' type='text/css'>	
	<link href="css/bootstrap.min.css" rel="stylesheet">
	<link href="css/font-awesome.min.css" rel="stylesheet">
	<link href="css/animate.min.css" rel="stylesheet">

	<!-- Script -->
	<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
	<script src="js/jquery.min.js"></script>
	<!-- Include all compiled plugins (below), or include individual files as needed -->
	<script src="js/bootstrap.min.js"></script>
	<script src="js/angular.min.js"></script>
<script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
  <script>tinymce.init({ selector:'textarea' });</script>
	<style type="text/css">
	input.ng-invalid.ng-dirty {
		border:1px solid red;
	}

	.frm-radios {
		margin-right:10px !important;
		float: left;
	}

.selectBox {
width:150px;
}

	.callOk {
		padding: 5px;
	    font-size: 9px;
	    background: #8BC34A;
	    border-radius: 50%;
	    color: #fff;
	}

	.callNotOk {
		padding: 5px;
		font-size: 9px;
		background: #F44336;
		border-radius: 50%;
		color:#fff;
	}

	.contentBody {
		/*margin-top:75px;*/
	}

	.alert.ajaxMsg {
		display: none;
	}

	.notice {
	    font-size: 13px;
	    color: #795548;
	}

	.form-control {
		color:#c80e00;
	}

	img#mySpinner {
    position: absolute;
    top: 40%;
    margin: 0 auto;
    width: 40px;
    left: 45%;
    z-index: 99999;
    display: none;
}
	</style>

</head>
<body>
<img id="mySpinner" src="cube.gif" />
	<div ng-app="myApp" ng-controller="usercontroller" ng-init="displayData()">

		<div class="container contentBody">

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">

					<form name="frm"  class="form-horizontal">

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Mobile</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custmobile" ng-model="customermobile" class="form-control" placeholder="Mobile Number" required autocomplete="off" ng-change="getCusData(customermobile)" ng-pattern="/^[0-9]{8,15}$/">
<span ng-show="frm.custmobile.$error.pattern">Not a valid number!</span>
<span ng-show="frm.customermobile.$dirty && frm.customermobile.$error.required">Required!</span>
							</div>
							<div class="col-lg-3 col-md-3 col-xs-12 col-sm-12 notice">If you have already registered, please enter the registered mobile number.</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Name</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custname" ng-model="customername" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Name" required autocomplete="off" ng-readonly="makeReadOnly" ng-pattern ="/^[a-zA-Z\s]*$/" >
<span ng-show="frm.custname.$error.pattern">Not a valid Name!</span>
								<span ng-show="frm.custname.$dirty && frm.custname.$error.required">Required!</span>
							</div>
						</div>
						
						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Email</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="email" name="custemail" ng-model="customeremail" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Email Id" required autocomplete="off" ng-readonly="makeReadOnly">
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.required">Required!</span>
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.email">Not an Email!</span>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Company</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custcompany" ng-model="customercompany" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Company Name" ng-readonly="makeReadOnly">
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Attending the Event</label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:110px;">
								<label>
								<input type="checkbox" ng-model="mycheck.chkbx" ng-change="checkAllCheckBoxes()"  class="custdisableall">
								All Days{{check.checkallDays}}</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]" id="custday1" ng-model="mycheck.customerday1"   ng-true-value="1" ng-false-value="0"  ng-checked="mycheck.customerday1 ==1" ng-change="checkAlldayschecked()"   class="custdisableall">
								Day 1</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]" id="custday2" ng-model="mycheck.customerday2" ng-true-value="2" ng-false-value="0"  ng-checked="mycheck.customerday2 ==2" ng-change="checkAlldayschecked()"  class="custdisableall">
								Day 2</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]" id="custday3" ng-model="mycheck.customerday3" ng-true-value="3" ng-false-value="0" ng-checked="mycheck.customerday3 ==3" ng-change="checkAlldayschecked()"  class="custdisableall">
								Day 3</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Individual" ng-checked="true"  ng-init="customerfamily='Individual'"  class="custdisableall">
								Individual</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Family"  class="custdisableall" >
								Family</label>
							</div>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12 familyCount" ng-show="customerfamily == 'Family'">
								<label class="control-label col-lg-5 col-md-5 col-xs-12 col-sm-12">No of Family Members</label>
								<div class="col-lg-3 col-md-3 col-xs-12 col-sm-12">
									<input type="number" name="custfamilyno" ng-model="customerfamilyno" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="No of family Members"  min="1" max="50" ng-init="customerfamilyno=1" ng-readonly="makeReadOnly">
								</div>
							</div>
						</div>

						<div class="form-group" style="margin-bottom:0px;">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-8 col-md-8 col-xs-12 col-sm-12">
								<label class="notice">Would you like to be contacted for IKKF’s future events?</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="Yes" ng-checked="true"  ng-init="customercontact='Yes'" ng-readonly="makeReadOnly"  class="custdisableall">
								Yes</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="No" class="custdisableall">
								No</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Feedback</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<textarea name="custremarks" ng-model="customerremarks" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Your Feedback about the program"></textarea>

							</div>
						</div>				

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input ng-disabled="frm.$invalid" type="submit" name="btnInsert" class="btn btn-info" ng-click="insertData()" value="Submit">
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<div class="alert alert-success ajaxMsg">
					  	  	  	  	<strong>Success!</strong> Thank you for submitting your Feedback.
					  	  	  	</div>
							</div>
						</div>

					</form>
				</div>
			</div>

		</div>

	</div>
	
</body>
<script type="text/javascript">

	var app=angular.module("myApp" , []);

	app.controller("usercontroller", function($scope, $http){

		$scope.mycheck = {'chkbx' : false, 'customerday1' : false, 'customerday2' : false, 'customerday3' : false	};
		//$scope.mycheck.chkbx = false;

		$scope.insertData= function(){
			if(tinyMCE.activeEditor.getContent().length==0){
alert("Please enter your feedback about the program.");
return false;
}

			$http.post(
				"postfeedbackSave.php",
				{'customername':$scope.customername, 'customeremail':$scope.customeremail, 'customermobile':$scope.customermobile, 'customercompany':$scope.customercompany, 'customerdays':$scope.mycheck.customerday1+','+$scope.mycheck.customerday2+','+$scope.mycheck.customerday3, 'customerfamily':$scope.customerfamily, 'customerfamilyno':$scope.customerfamilyno, 'customercontact':$scope.customercontact, 'customerremarks':tinyMCE.activeEditor.getContent() }
			).success(function(data){
				console.log(data);
				$(".ajaxMsg").fadeIn();
				$scope.customername=null;
				$scope.customeremail=null;
				$scope.customermobile=null;
				$scope.customercompany=null;
				tinyMCE.activeEditor.setContent('');
				$scope.customerfamilyno='0';
				$scope.mycheck.customerday1=false;
				$scope.mycheck.customerday2=false;
				$scope.mycheck.customerday3=false;
				$scope.frm.$setPristine();
				$scope.makeReadOnly = true;
				

				setTimeout(function() {
				    $('.ajaxMsg').fadeOut('fast');
				}, 7000); // <-- time in milliseconds
			});
		}

		$scope.checkAllCheckBoxes = function(){
	        
	            $scope.mycheck.customerday1 = ($scope.mycheck.chkbx === true ? 1 : 0);
	            $scope.mycheck.customerday2 = ($scope.mycheck.chkbx === true ? 2 : 0);
	            $scope.mycheck.customerday3 = ($scope.mycheck.chkbx === true ? 3 : 0);

	    }

	    $scope.checkAlldayschecked = function(){
	    	n=0
	    	if($scope.mycheck.customerday1=='1')
	    	{
	    		n++;
	    	}
	    	if($scope.mycheck.customerday2=='2')
	    	{
	    		n++;
	    	}
	    	if($scope.mycheck.customerday3=='3')
	    	{
	    		n++;
	    	}

	    	if(n==3)
			{
				$scope.mycheck.chkbx=true;
			}
			else
			{
				$scope.mycheck.chkbx=false;
			}
	    }



		$scope.getCusData = function(customermobile){
			
			var parameters = {
			       custmobile: $scope.customermobile 
			};
			var config = {
			       params: parameters
			};

			
			$scope.loading = true;
			$("#mySpinner").show();
			$http.get("getCustData.php",config )
			.success(function(data){
				i=0;
				if(data.length>0){
					$scope.customeremail=data[0].email;
					$scope.customername=data[0].name;
					$scope.customercompany=data[0].company;
					$scope.customerfamily=data[0].attending_with;
					$scope.customercontact=data[0].contactback;
					$scope.customerfamilyno=parseInt(data[0].family_members, 10);
					tinyMCE.activeEditor.setContent('');
					day1=data[0].days.split(',')[0];
					day2=data[0].days.split(',')[1];
					day3=data[0].days.split(',')[2];
					if(day1!='')
					{
						$scope.mycheck.customerday1=day1;
						i++;
					}
					
					if(day2!='')
					{
						$scope.mycheck.customerday2=day2;
						i++;
					}

					if(day3!='')
					{
						$scope.mycheck.customerday3=day3;
						i++;
					}
					if(i==3)
					{
						$scope.mycheck.chkbx=true;
					}
					else
					{
						$scope.mycheck.chkbx=false;
					}
					$scope.makeReadOnly = true;
					$(".custdisableall").attr('disabled','disabled');
				}
				else
				{
					$scope.customeremail='';
					$scope.customername='';
					$scope.customercompany='';
					$scope.mycheck.customerday1='';
					$scope.mycheck.customerday2='';
					$scope.mycheck.customerday3='';
					$scope.mycheck.chkbx=false;
					$scope.customerfamily='Individual';
					$scope.customercontact='Yes';
					$scope.customerfamilyno=1;
					$scope.makeReadOnly = false;
					$(".custdisableall").removeAttr('disabled');
				}
			})
			.finally(function () {
			    // Hide loading spinner whether our call succeeded or failed.
			    $("#mySpinner").hide();
			   $scope.loading = false;
			});
		}

	});
</script>
</html>