<?php
require './old/inc/header.php';
?>

		<div class="container contentBody">

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">

					<div class="alert alert-success ajaxMsg">
					  	<strong>Success!</strong> Customer Details Recorded.
					</div>

				</div>

			</div>

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">

					<form name="frm"  class="form-horizontal">

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Mobile</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custmobile" ng-model="customermobile" class="form-control" placeholder="Mobile Number" required autocomplete="off" ng-change="getCusData(customermobile)">
								<span ng-show="frm.customermobile.$dirty && frm.customermobile.$error.required">Required!</span>
							</div>
							<div class="col-lg-4 col-md-4 col-xs-12 col-sm-12">If you are preregistered, please enter your previously entered number.</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Name</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custname" ng-model="customername" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Name" required autocomplete="off">
								<span ng-show="frm.custname.$dirty && frm.custname.$error.required">Required!</span>
							</div>
						</div>
						
						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Email</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="email" name="custemail" ng-model="customeremail" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Email Id" required autocomplete="off">
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.required">Required!</span>
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.email">Not an Email!</span>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Company</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custcompany" ng-model="customercompany" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Company Name">
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Attending the Event</label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custday"  ng-model="customerday" value="1" ng-checked="true"  ng-init="customerday=1">
								Day 1</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custday"  ng-model="customerday" value="2">
								Day 2</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custday"  ng-model="customerday" value="3">
								Day 3</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Individual" ng-checked="true"  ng-init="customerfamily='Individual'">
								Individual</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Family">
								Family</label>
							</div>
							<div class="col-lg-7 col-md-7 col-xs-12 col-sm-12">
								<label class="control-label col-lg-5 col-md-5 col-xs-12 col-sm-12">No of Family Members Attending</label>
								<div class="col-lg-3 col-md-3 col-xs-12 col-sm-12">
									<input type="number" name="custfamilyno" ng-model="customerfamilyno" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="No of family Members"  min="1" max="50" ng-init="customerfamilyno=1">
								</div>
							</div>
						</div>

						<div class="form-group" style="margin-bottom:0px;">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12"></label>
							<div class="col-lg-8 col-md-8 col-xs-12 col-sm-12">
								<label class="notice">Would you like to be contacted for IKKF’s future events?</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="Yes" ng-checked="true"  ng-init="customercontact='Yes'">
								Yes</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="No">
								No</label>
							</div>
						</div>

						<div class="form-group" style="margin-bottom:0px;">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12"></label>
							<label class="col-lg-8 col-md-8 col-xs-12 col-sm-12 notice">We will contact you later for your feedback about the event</label>
						</div>		

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12">Feedback</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<textarea name="custremarks" ng-model="customerremarks" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Your Feedback about the program"></textarea>
							</div>
						</div>				

						<div class="form-group">
							<label class="control-label col-lg-2 col-md-2 col-xs-12 col-sm-12"></label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input ng-disabled="frm.$invalid" type="submit" name="btnInsert" class="btn btn-info" ng-click="insertData()" value="Add Customer Details">
							</div>
						</div>

					</form>
				</div>
			</div>

		</div>

	</div>
	
</body>
<script type="text/javascript">

	var app=angular.module("myApp" , []);

	app.controller("usercontroller", function($scope, $http){

		$scope.insertData= function(){
			$http.post(
				"insert.php",
				{'customername':$scope.customername, 'customeremail':$scope.customeremail, 'customermobile':$scope.customermobile, 'customercompany':$scope.customercompany, 'customerdays':$scope.customerday, 'customerfamily':$scope.customerfamily, 'customerfamilyno':$scope.customerfamilyno, 'customercontact':$scope.customercontact,'customerremarks':$scope.customerremarks }
			).success(function(data){
				console.log(data);
				$(".ajaxMsg").fadeIn();
				$scope.customername=null;
				$scope.customeremail=null;
				$scope.customermobile=null;
				$scope.customercompany=null;
				$scope.customerremarks=null;
				$scope.customerfamilyno='0';
				$scope.customerday=false;
				$scope.frm.$setPristine();

				setTimeout(function() {
				    $('.ajaxMsg').fadeOut('fast');
				}, 2000); // <-- time in milliseconds
			});
		}


		$scope.getCusData = function(customermobile){

			var parameters = {
			       custmobile: $scope.customermobile 
			};
			var config = {
			       params: parameters
			};

			$http.get("getCustData.php",config )
			.success(function(data){
				if(data.length>0){
					$scope.customeremail=data[0].email;
					$scope.customername=data[0].name;
					$scope.customercompany=data[0].company;
					$scope.customerfamily=data[0].attending_with;
					$scope.customercontact=data[0].contactback;
					$scope.customerfamilyno=parseInt(data[0].family_members, 10);
				}
				else
				{
					$scope.customeremail='';
					$scope.customername='';
					$scope.customercompany='';
					$scope.customerday1='';
					$scope.customerday2='';
					$scope.customerday3='';
					$scope.customerfamily='Individual';
					$scope.customercontact='Yes';
					$scope.customerfamilyno=1;
				}
			})
		}

	});

</script>
</html>