<?php
require './inc/header.php';
?>

		<div class="container contentBody">

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">
					<button class="btn btn-link"  ng-click="exportData()">Export to Excel</button>
				</div>

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12" id="custReport">

					<table class="table table-bordered">

						<thead>
							<th>#</th>
							<th>Name</th>
							<th>Email</th>
							<th>Mobile</th>
							<th>Company</th>
							<th>Day</th>							
							<th>Attended</th>
							<th>Members</th>
							<th>Feedback</th>
							<th>CallBack</th>
							<th>Date ( UAE Time)</th>
						</thead>
						<tbody>
							<tr ng-repeat="x in names">
								<td>{{ $index + 1 }}</td>
								<td>{{x.name}}</td>
								<td>{{x.email}}</td>
								<td>{{x.mobile}}</td>
								<td>{{x.company}}</td>
								<td>{{x.day}}</td>
								<td>{{x.attending_with}}</td>
								<td>{{x.family_members}}</td>
								<td><p ng-bind-html="x.feedback"></p></td>
								<td><span ng-if="x.contactback=='Yes'">Yes</span><span ng-if="x.contactback=='No'" >No</span></td>
								<td>{{x.entrydate | date:'d/m/yyyy'}}</td>
							</tr>
						</tbody>
					</table>

				</div>

			</div>

		</div>

	</div>
	
</body>
<script type="text/javascript">

	var app=angular.module("myApp" , ['ngSanitize']);

	app.controller("usercontroller", function($scope, $http){

		$scope.displayData = function(){
			$http.get("feedbackview.php")
			.success(function(data){
				$scope.names = data;
			})
		}


		$scope.exportData = function () {
			var blob = new Blob([document.getElementById('custReport').innerHTML], {
			type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8"
			});
			saveAs(blob, "Customers.xls");
		};
	});

</script>
</html>