<?php
require './inc/header.php';
?>

		<div class="container contentBody">

			<div class="row">

				<div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">

					<form name="frm"  class="form-horizontal">

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Mobile</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custmobile" ng-model="customermobile" class="form-control" placeholder="Mobile Number" required autocomplete="off" ng-change="getCusData(customermobile)" ng-pattern="/^[0-9]{8,15}$/">
<span ng-show="frm.custmobile.$error.pattern">Not a valid number!</span>
<span ng-show="frm.customermobile.$dirty && frm.customermobile.$error.required">Required!</span>
							</div>
							<div class="col-lg-3 col-md-3 col-xs-12 col-sm-12 notice">If you have already registered, please enter the registered mobile number.</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Name</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custname" ng-model="customername" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Name" required autocomplete="off" ng-pattern ="/^[a-zA-Z\s]*$/" >
<span ng-show="frm.custname.$error.pattern">Not a valid Name!</span>
								<span ng-show="frm.custname.$dirty && frm.custname.$error.required">Required!</span>
							</div>
						</div>
						
						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Email</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="email" name="custemail" ng-model="customeremail" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Email Id" required autocomplete="off" >
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.required">Required!</span>
								<span ng-show="frm.custemail.$dirty && frm.custemail.$error.email">Not an Email!</span>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Company</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input type="text" name="custcompany" ng-model="customercompany" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Company Name" >
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Attending the Event</label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:110px;">
								<label>
								<input type="checkbox" ng-model="mycheck.chkbx" ng-change="checkAllCheckBoxes()">
								All Days{{check.checkallDays}}</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]" ng-model="mycheck.customerday1"   ng-true-value="1" ng-false-value="0"  ng-checked="mycheck.customerday1 ==1" ng-change="checkAlldayschecked()">
								Day 1</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]" ng-model="mycheck.customerday2" ng-true-value="2" ng-false-value="0"  ng-checked="mycheck.customerday2 ==2" ng-change="checkAlldayschecked()">
								Day 2</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]"  ng-model="mycheck.customerday3" ng-true-value="3" ng-false-value="0" ng-checked="mycheck.customerday3 ==3" ng-change="checkAlldayschecked()">
								Day 3</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
								<label>
								<input type="checkbox" name="custday[]"  ng-model="mycheck.customerday4" ng-true-value="4" ng-false-value="0" ng-checked="mycheck.customerday4 ==4" ng-change="checkAlldayschecked()">
								Day 4</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Individual" ng-checked="true"  ng-init="customerfamily='Individual'">
								Individual</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
								<label>
								<input type="radio" name="custfamily"  ng-model="customerfamily" value="Family">
								Family</label>
							</div>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12 familyCount" ng-show="customerfamily == 'Family'">
								<label class="control-label col-lg-5 col-md-5 col-xs-12 col-sm-12">No of Family Members</label>
								<div class="col-lg-3 col-md-3 col-xs-12 col-sm-12">
									<input type="number" name="custfamilyno" ng-model="customerfamilyno" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="No of family Members"  min="1" max="50" ng-init="customerfamilyno=1">
								</div>
							</div>
						</div>

						<div class="form-group" style="margin-bottom:0px;">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-8 col-md-8 col-xs-12 col-sm-12">
								<label class="notice">Would you like to be contacted for IKKF’s future events?</label>
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="Yes" ng-checked="true"  ng-init="customercontact='Yes'">
								Yes</label>
							</div>
							<div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
								<label>
								<input type="radio" name="custcontact"  ng-model="customercontact" value="No">
								No</label>
							</div>
						</div>

						<div class="form-group" style="margin-bottom:0px;">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<label class="col-lg-8 col-md-8 col-xs-12 col-sm-12 notice">We will be contacting you after the event for your feedback.</label>
						</div>		

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Feedback</label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<textarea name="custremarks" ng-model="customerremarks" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Your Feedback about the program" disabled></textarea>
							</div>
						</div>				

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<input ng-disabled="frm.$invalid" type="submit" name="btnInsert" class="btn btn-info" ng-click="insertData()" value="Submit">
							</div>
						</div>

						<div class="form-group">
							<label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
							<div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
								<div class="alert alert-success ajaxMsg">
					  	  	  	  	<strong>Success!</strong> Thank you for submitting your Details.
					  	  	  	</div>
							</div>
						</div>

					</form>
				</div>
			</div>

		</div>

	</div>
	
</body>
<script type="text/javascript">

	var app=angular.module("myApp" , []);

	app.controller("usercontroller", function($scope, $http){

		$scope.mycheck = {'chkbx' : false, 'customerday1' : false, 'customerday2' : false, 'customerday3' : false, 'customerday4' : false	};
		//$scope.mycheck.chkbx = false;

		$scope.insertData= function(){
			console.log($scope.mycheck.customerday1+','+$scope.mycheck.customerday2+','+$scope.mycheck.customerday3+','+$scope.mycheck.customerday4);

			$http.post(
				"insertCustomerAdmin.php",
				{'customername':$scope.customername, 'customeremail':$scope.customeremail, 'customermobile':$scope.customermobile, 'customercompany':$scope.customercompany, 'customerdays':$scope.mycheck.customerday1+','+$scope.mycheck.customerday2+','+$scope.mycheck.customerday3+','+$scope.mycheck.customerday4, 'customerfamily':$scope.customerfamily, 'customerfamilyno':$scope.customerfamilyno, 'customercontact':$scope.customercontact }
			).success(function(data){
				console.log(data);
				$(".ajaxMsg").fadeIn();
				$scope.customername=null;
				$scope.customeremail=null;
				$scope.customermobile=null;
				$scope.customercompany=null;
				$scope.customerremarks=null;
				$scope.customerfamilyno='0';
				$scope.mycheck.customerday1=false;
				$scope.mycheck.customerday2=false;
				$scope.mycheck.customerday3=false;
				$scope.mycheck.customerday4=false;
				$scope.frm.$setPristine();
				$scope.makeReadOnly = true;

				setTimeout(function() {
				    $('.ajaxMsg').fadeOut('fast');
				}, 7000); // <-- time in milliseconds
			});
		}

		$scope.checkAllCheckBoxes = function(){
	        
	            $scope.mycheck.customerday1 = ($scope.mycheck.chkbx === true ? 1 : 0);
	            $scope.mycheck.customerday2 = ($scope.mycheck.chkbx === true ? 2 : 0);
	            $scope.mycheck.customerday3 = ($scope.mycheck.chkbx === true ? 3 : 0);
	            $scope.mycheck.customerday4 = ($scope.mycheck.chkbx === true ? 4 : 0);

	    }

	    $scope.checkAlldayschecked = function(){
	    	n=0
	    	if($scope.mycheck.customerday1=='1')
	    	{
	    		n++;
	    	}
	    	if($scope.mycheck.customerday2=='2')
	    	{
	    		n++;
	    	}
	    	if($scope.mycheck.customerday3=='3')
	    	{
	    		n++;
	    	}
	    	if($scope.mycheck.customerday4=='4')
	    	{
	    		n++;
	    	}

	    	if(n==4)
			{
				$scope.mycheck.chkbx=true;
			}
			else
			{
				$scope.mycheck.chkbx=false;
			}
	    }

		$scope.getCusData = function(customermobile){

			var parameters = {
			       custmobile: $scope.customermobile 
			};
			var config = {
			       params: parameters
			};

			

			$http.get("getCustData.php",config )
			.success(function(data){
				i=0;
				if(data.length>0){
					$scope.customeremail=data[0].email;
					$scope.customername=data[0].name;
					$scope.customercompany=data[0].company;
					$scope.customerfamily=data[0].attending_with;
					$scope.customercontact=data[0].contactback;
					$scope.customerfamilyno=parseInt(data[0].family_members, 10);
					day1=data[0].days.split(',')[0];
					day2=data[0].days.split(',')[1];
					day3=data[0].days.split(',')[2];
					day4=data[0].days.split(',')[3];
					if(day1!='')
					{
						$scope.mycheck.customerday1=day1;
						i++;
					}
					
					if(day2!='')
					{
						$scope.mycheck.customerday2=day2;
						i++;
					}

					if(day3!='')
					{
						$scope.mycheck.customerday3=day3;
						i++;
					}
					
					if(day4!='')
					{
						$scope.mycheck.customerday4=day4;
						i++;
					}
					if(i==4)
					{
						$scope.mycheck.chkbx=true;
					}
					else
					{
						$scope.mycheck.chkbx=false;
					}
					$scope.makeReadOnly = true;
				}
				else
				{
					$scope.customeremail='';
					$scope.customername='';
					$scope.customercompany='';
					$scope.mycheck.customerday1='';
					$scope.mycheck.customerday2='';
					$scope.mycheck.customerday3='';
					$scope.mycheck.customerday4='';
					$scope.mycheck.chkbx=false;
					$scope.customerfamily='Individual';
					$scope.customercontact='Yes';
					$scope.customerfamilyno=1;
					$scope.makeReadOnly = false;
				}
			})
		}

	});

</script>
</html>