<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>IKKF 2019 Customer Data Collection</title>
    <!-- Bootstrap -->
    <link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,200' rel='stylesheet' type='text/css'>   
    <link href="old/css/bootstrap.min.css" rel="stylesheet">
    <link href="old/css/font-awesome.min.css" rel="stylesheet">
    <link href="old/css/animate.min.css" rel="stylesheet">

    <!-- Script -->
    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="old/js/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="old/js/bootstrap.min.js"></script>
    <script src="old/js/angular.min.js"></script>
    
    <link href="images/favicon.png" rel="shortcut icon">
  <link href="images/favicon.ico" rel="icon" type="image/x-icon">
  <link rel="stylesheet" href="css/fontawesome.min.css">
  <link rel="stylesheet" href="css/odometer.min.css">
  <link rel="stylesheet" href="css/fancybox.min.css">
  <link rel="stylesheet" href="css/swiper.min.css">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="popup/magnific-popup.css">
  <link rel="stylesheet" href="css/schedule.css">
  <link rel="stylesheet" href="css/style.css">

    <style type="text/css">
    
    ::-webkit-scrollbar-track
    {
    	-webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.3);
    	background-color: #F5F5F5;
    }
    
    ::-webkit-scrollbar
    {
    	width: 6px;
    	background-color: #F5F5F5;
    }
    
    ::-webkit-scrollbar-thumb
    {
    	background-color: #bf202f;
    }

    
    .page-header {
        width: 100%;
        max-height: 140px;
    }

    @media only screen and (max-width: 991px) {
    
        .page-header {
            width: 100%;
            max-height: 100px;
        }
    
    }
    input.ng-invalid.ng-dirty {
        border:1px solid red;
    }

    .frm-radios {
        margin-right:10px !important;
        float: left;
    }

.selectBox {
width:150px;
}

    .callOk {
        padding: 5px;
        font-size: 9px;
        background: #8BC34A;
        border-radius: 50%;
        color: #fff;
    }

    .callNotOk {
        padding: 5px;
        font-size: 9px;
        background: #F44336;
        border-radius: 50%;
        color:#fff;
    }

    .contentBody {
        /*margin-top:75px;*/
    }

    .alert.ajaxMsg {
        display: none;
    }

    .notice {
        font-size: 13px;
        color: #795548;
    }

    .form-control {
        color:#c80e00;
    }
    </style>

</head>
<body>
<body>
  <div class="preloader" id="preloader">
    <svg viewBox="0 0 1920 1080" preserveAspectRatio="none" version="1.1">
      <path
        d="M0,0 C305.333333,0 625.333333,0 960,0 C1294.66667,0 1614.66667,0 1920,0 L1920,1080 C1614.66667,1080 1294.66667,1080 960,1080 C625.333333,1080 305.333333,1080 0,1080 L0,0 Z">
      </path>
    </svg>
    <div class="inner">
      <canvas class="progress-bar" id="progress-bar" width="200" height="200"></canvas>
      <figure><img src="images/icon.png" alt="Image"></figure>
    </div>
  </div>
  <div class="page-transition">
    <svg viewBox="0 0 1920 1080" preserveAspectRatio="none" version="1.1">
      <path
        d="M0,0 C305.333333,0 625.333333,0 960,0 C1294.66667,0 1614.66667,0 1920,0 L1920,1080 C1614.66667,980 1294.66667,930 960,930 C625.333333,930 305.333333,980 0,1080 L0,0 Z">
      </path>
    </svg>
  </div>
  <div class="smooth-scroll">
    <div class="section-wrapper" data-scroll-section>
      <div class="search-box">
        <div class="container">
          <div class="form">
            <h3>SEARCH EVENT</h3>
            <input type="search" placeholder="What are you looking for ?">
            <input type="submit" value="SEARCH">
          </div>

        </div>
      </div>
      <aside class="side-widget">
        <svg viewBox="0 0 600 1080" preserveAspectRatio="none" version="1.1">
          <path d="M540,1080H0V0h540c0,179.85,0,359.7,0,539.54C540,719.7,540,899.85,540,1080z"></path>
        </svg>
        <figure class="logo"> <img src="images/logo.png" alt="Image"> </figure>
        <div class="display-mobile">
          <div class="custom-menu"> </div>
          <div class="site-menu">
            <ul>
              <li><a href="https://play.perutions.com/ikkf/website/">Home</a></li>
              <li><a href="https://play.perutions.com/ikkf/website/about">About IKKF</a></li>
              <li><a href="https://play.perutions.com/ikkf/website/events">Events </a></li>
              <li><a href="https://play.perutions.com/ikkf/website/schedule">Schedule </a></li>
              <li><a href="https://play.perutions.com/ikkf/visitor/customer.php">Visitor registration</a></li>
              <li><a href="https://play.perutions.com/ikkf/website/contact">Contact</a></li>
            </ul>
          </div>
        </div>
      </aside>
      <nav class="navbar">
        <div class="logo"> <a href="https://play.perutions.com/ikkf/website/"> <img src="images/logo.png" alt="Image"> </a> </div>
        <div class="site-menu ms-auto">
          <ul>
            <li class="active"><a href="https://play.perutions.com/ikkf/website/">Home</a></li>
            <li><a href="https://play.perutions.com/ikkf/website/about">About IKKF</a></li>
            <li><a href="https://play.perutions.com/ikkf/website/events">Events </a></li>
            <li><a href="https://play.perutions.com/ikkf/website/schedule">Schedule </a></li>
            <li><a href="https://play.perutions.com/ikkf/visitor/customer.php">Visitor registration</a></li>
            <li class="d-lg-none"><a href="https://play.perutions.com/ikkf/website/contact">Contact</a></li>
          </ul>
        </div>
        <div class="navbar-button"> <a href="contact">Contact us</a> </div>
        <!--<div class="search-button"> <i class="far fa-search"></i> </div>-->
        <div class="hamburger-menu d-lg-none">
          <svg class="hamburger" width="30" height="30" viewBox="0 0 30 30">
            <path class="line line-top" d="M0,9h30" />
            <path class="line line-center" d="M0,15h30" />
            <path class="line line-bottom" d="M0,21h30" />
          </svg>
        </div>
      </nav>
    <header class="page-header" data-background="images/page-header.jpg">
        
    </header>
    <section class="schedule-section">  

          

    <div ng-app="myApp" ng-controller="usercontroller" ng-init="displayData()">

        <div class="container contentBody">

            <div class="row">
                <h1 style="margin-bottom: 50px;text-align: center;">IKKF Visitor Registration</h1>
                <div class="col-lg-12 col-md-12 col-xs-12 col-sm-12">

                    <form name="frm"  class="form-horizontal">                        
                        
                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Email</label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <input type="email" name="custemail" ng-model="customeremail" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Email Id" required autocomplete="off" ng-change="getCusData(customeremail)">
                                <div class="col-lg-12 col-md-12 col-xs-12 col-sm-12 notice">If you have already registered, please enter the registered Email Id.</div>
                                <span ng-show="frm.custemail.$dirty && frm.custemail.$error.required">Required!</span>
                                <span ng-show="frm.custemail.$dirty && frm.custemail.$error.email">Not an Email!</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Contact Number</label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <input type="text" name="custmobile" ng-model="customermobile" class="form-control" placeholder="Contact Number" required autocomplete="off"  ng-pattern="/^[0-9]{8,15}$/" ng-readonly="makeReadOnly" >
<span ng-show="frm.custmobile.$error.pattern">Not a valid number!</span>
<span ng-show="frm.customermobile.$dirty && frm.customermobile.$error.required">Required!</span>
                            </div>
                            
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Name</label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <input type="text" name="custname" ng-model="customername" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Name" required autocomplete="off" ng-readonly="makeReadOnly" ng-pattern ="/^[a-zA-Z\s]*$/">
<span ng-show="frm.custname.$error.pattern">Not a valid Name!</span>
                                <span ng-show="frm.custname.$dirty && frm.custname.$error.required">Required!</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Company</label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <input type="text" name="custcompany" ng-model="customercompany" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Company Name" ng-readonly="makeReadOnly">
                            </div>
                        </div>

                        <div class="form-group" style="display:none;">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Attending the Event</label>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:110px;">
                                <label>
                                <input type="checkbox" ng-model="mycheck.chkbx" ng-change="checkAllCheckBoxes()">
                                All Days{{check.checkallDays}}</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
                                <label>
                                <input type="checkbox" name="custday[]" ng-model="mycheck.customerday1"   ng-true-value="1" ng-false-value="0"  ng-checked="mycheck.customerday1 ==1" ng-change="checkAlldayschecked()">
                                Day 1</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
                                <label>
                                <input type="checkbox" name="custday[]" ng-model="mycheck.customerday2" ng-true-value="2" ng-false-value="0"  ng-checked="mycheck.customerday2 ==2" ng-change="checkAlldayschecked()">
                                Day 2</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
                                <label>
                                <input type="checkbox" name="custday[]"  ng-model="mycheck.customerday3" ng-true-value="3" ng-false-value="0" ng-checked="mycheck.customerday3 ==3" ng-change="checkAlldayschecked()">
                                Day 3</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:90px;">
                                <label>
                                <input type="checkbox" name="custday[]"  ng-model="mycheck.customerday4" ng-true-value="4" ng-false-value="0" ng-checked="mycheck.customerday4 ==4" ng-change="checkAlldayschecked()">
                                Day 4</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
                                <label>
                                <input type="radio" name="custfamily"  ng-model="customerfamily" value="Individual" ng-checked="true"  ng-init="customerfamily='Individual'">
                                Individual</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12" style="min-width:115px;">
                                <label>
                                <input type="radio" name="custfamily"  ng-model="customerfamily" value="Family">
                                Family</label>
                            </div>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12 familyCount" ng-show="customerfamily == 'Family'">
                                <label class="control-label col-lg-5 col-md-5 col-xs-12 col-sm-12">No of Family Members</label>
                                <div class="col-lg-3 col-md-3 col-xs-12 col-sm-12">
                                    <input type="number" name="custfamilyno" ng-model="customerfamilyno" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="No of family Members"  min="1" max="50" ng-init="customerfamilyno=1">
                                </div>
                            </div>
                        </div>

                        <div class="form-group" style="margin-bottom:0px;">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <div class="col-lg-8 col-md-8 col-xs-12 col-sm-12">
                                <label class="notice">Would you like to be contacted for IKKF’s future events?</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
                                <label>
                                <input type="radio" name="custcontact"  ng-model="customercontact" value="Yes" ng-checked="true"  ng-init="customercontact='Yes'">
                                Yes</label>
                            </div>
                            <div class="col-lg-1 col-md-1 col-xs-12 col-sm-12">
                                <label>
                                <input type="radio" name="custcontact"  ng-model="customercontact" value="No">
                                No</label>
                            </div>
                        </div>

                        <div class="form-group" style="margin-bottom:0px;display:none;">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <label class="col-lg-8 col-md-8 col-xs-12 col-sm-12 notice">We will be contacting you after the event for your feedback.</label>
                        </div>      

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12">Suggestions & Feedback</label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <textarea name="custremarks" ng-model="customerremarks" class="form-control col-lg-10 col-md-10 col-xs-12 col-sm-12" placeholder="Your Feedback about the program" ></textarea>
                            </div>
                        </div>              

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <input ng-disabled="frm.$invalid" type="submit" name="btnInsert" class="btn btn-info" ng-click="insertData()" value="Submit">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label col-lg-3 col-md-3 col-xs-12 col-sm-12"></label>
                            <div class="col-lg-6 col-md-6 col-xs-12 col-sm-12">
                                <div class="alert alert-success ajaxMsg">
                                    <strong>Success!</strong> Thank you for submitting your Details.
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>

        </div>

    </div>
    </section>
    <footer class="footer">
        <div class="container">
          <div class="row">
            <div class="col-lg-4 col-md-12">
              <h6 class="widget-title">About us</h6>
              <p>Utsavam IKKF is a Dubai-based event management company of art-lovers, run by art-lovers, for
                art-lovers. Our team has the rich experience and credibility of organising several highly successful
                traditional arts festivals in and around Dubai for the past several years. </p>


            </div>
            <div class="col-lg-4 col-sm-6">
              <h6 class="widget-title">Quick links</h6>
              <ul class="footer-menu">
                <li><a href="https://play.perutions.com/ikkf/website/about">About IKKF </a></li>
                <li><a href="https://play.perutions.com/ikkf/website/events">Events</a></li>
                <li><a href="https://play.perutions.com/ikkf/visitor/customer.php">Visitor Registration</a></li>
                <li><a href="https://play.perutions.com/ikkf/website/contact">Contact us</a></li>
              </ul>

            </div>
            <div class="col-lg-4 col-sm-6">
              <h6 class="widget-title">Connect Us </h6>
              <ul class="social-media">
                <li><a href="https://www.facebook.com/IKKF22" target="_blank"><i class="fab fa-facebook-f"></i> Facebook
                  </a></li>
                <li><a href="https://www.youtube.com/@traditionslive4265" target="_blank"><i class="fab fa-youtube"></i>
                    Youtube </a></li>
                    <li><a href="https://www.instagram.com/" target="_blank"><i class="fab fa-instagram"></i>  Instagram</a></li>
                <li><a href="#"><i class="fa fa-envelope"></i> rema@utsavamikkf.org</a></li>
              </ul>
            </div>
          </div>
        </div>
        <div class="footer-bottom">
          <div class="container"> <span class="copyright">© 2023 Utsavam IKKF | All rights reserved</span> <span
              class="creation">Web Design by <a href="https://www.perutions.com/" target="_blank">Perutions Infini</a></span>
          </div>
        </div>
      </footer>
    </div>
  </div>
</body>
<script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/gsap.min.js"></script>
  <script src="js/locomotive-scroll.min.js"></script>
  <script src="js/ScrollTrigger.min.js"></script>
  <script src="js/kinetic-slider.js"></script>
  <script src="js/fancybox.min.js"></script>
  <script src="js/odometer.min.js"></script>
  <script src="js/swiper.min.js"></script>
  <script src="js/scripts.js"></script>
  <script src="popup/magnific-popup.min.js"></script>
  <script src="js/schedule.js"></script>
<script type="text/javascript">

    var app=angular.module("myApp" , []);

    app.controller("usercontroller", function($scope, $http){

        $scope.mycheck = {'chkbx' : false, 'customerday1' : false, 'customerday2' : false, 'customerday3' : false, 'customerday4' : false   };
        //$scope.mycheck.chkbx = false;

        $scope.insertData= function(){
            console.log($scope.mycheck.customerday1+','+$scope.mycheck.customerday2+','+$scope.mycheck.customerday3+','+$scope.mycheck.customerday4);

            $http.post(
                "insertCustomer.php",
                {'customername':$scope.customername, 'customeremail':$scope.customeremail, 'customermobile':$scope.customermobile, 'customercompany':$scope.customercompany, 'customerdays':$scope.mycheck.customerday1+','+$scope.mycheck.customerday2+','+$scope.mycheck.customerday3+','+$scope.mycheck.customerday4, 'customerfamily':$scope.customerfamily, 'customerfamilyno':$scope.customerfamilyno, 'customercontact':$scope.customercontact, 'customerremarks':$scope.customerremarks }
            ).success(function(data){
                console.log(data);
                $(".ajaxMsg").fadeIn();
                $scope.customername=null;
                $scope.customeremail=null;
                $scope.customermobile=null;
                $scope.customercompany=null;
                $scope.customerremarks=null;
                $scope.customerfamilyno='0';
                $scope.mycheck.customerday1=false;
                $scope.mycheck.customerday2=false;
                $scope.mycheck.customerday3=false;
                $scope.mycheck.customerday4=false;
                $scope.frm.$setPristine();
                $scope.makeReadOnly = true;

                setTimeout(function() {
                    $('.ajaxMsg').fadeOut('fast');
                }, 7000); // <-- time in milliseconds
            });
        }

        $scope.checkAllCheckBoxes = function(){
            
                $scope.mycheck.customerday1 = ($scope.mycheck.chkbx === true ? 1 : 0);
                $scope.mycheck.customerday2 = ($scope.mycheck.chkbx === true ? 2 : 0);
                $scope.mycheck.customerday3 = ($scope.mycheck.chkbx === true ? 3 : 0);
                $scope.mycheck.customerday4 = ($scope.mycheck.chkbx === true ? 4 : 0);

        }

        $scope.checkAlldayschecked = function(){
            n=0
            if($scope.mycheck.customerday1=='1')
            {
                n++;
            }
            if($scope.mycheck.customerday2=='2')
            {
                n++;
            }
            if($scope.mycheck.customerday3=='3')
            {
                n++;
            }
            if($scope.mycheck.customerday4=='4')
            {
                n++;
            }

            if(n==4)
            {
                $scope.mycheck.chkbx=true;
            }
            else
            {
                $scope.mycheck.chkbx=false;
            }
        }

        $scope.getCusData = function(customeremail){

            var parameters = {
                   custmobile: $scope.customeremail 
            };
            var config = {
                   params: parameters
            };

            

            $http.get("getCustData.php",config )
            .success(function(data){
                i=0;
                console.log(data);
                if(data.length>0){
                    $scope.customermobile=data[0].mobile;
                    $scope.customername=data[0].name;
                    $scope.customercompany=data[0].company;
                    $scope.customerfamily=data[0].attending_with;
                    $scope.customercontact=data[0].contactback;
                    $scope.customerfamilyno=parseInt(data[0].family_members, 10);
                    day1=data[0].days.split(',')[0];
                    day2=data[0].days.split(',')[1];
                    day3=data[0].days.split(',')[2];
                    day4=data[0].days.split(',')[3];
                    if(day1!='')
                    {
                        $scope.mycheck.customerday1=day1;
                        i++;
                    }
                    
                    if(day2!='')
                    {
                        $scope.mycheck.customerday2=day2;
                        i++;
                    }

                    if(day3!='')
                    {
                        $scope.mycheck.customerday3=day3;
                        i++;
                    }

                    if(day4!='')
                    {
                        $scope.mycheck.customerday4=day4;
                        i++;
                    }
                    if(i==4)
                    {
                        $scope.mycheck.chkbx=true;
                    }
                    else
                    {
                        $scope.mycheck.chkbx=false;
                    }
                    $scope.makeReadOnly = true;
                }
                else
                {
                    $scope.customermobile='';
                    $scope.customername='';
                    $scope.customercompany='';
                    $scope.mycheck.customerday1='';
                    $scope.mycheck.customerday2='';
                    $scope.mycheck.customerday3='';
                    $scope.mycheck.customerday4='';
                    $scope.mycheck.chkbx=false;
                    $scope.customerfamily='Individual';
                    $scope.customercontact='Yes';
                    $scope.customerfamilyno=1;
                    $scope.makeReadOnly = false;
                }
            })
        }

    });

</script>
</html>